/*
 * CollisionHandlerEventNodeCollection.h
 *
 * Created 8/11/2009 By Johnny Huynh
 *
 * Version 00.00.02 8/19/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef COLLISION_HANDLER_EVENT_NODE_COLLECTION_H
 #define COLLISION_HANDLER_EVENT_NODE_COLLECTION_H
 
 template <typename T> class CollisionHandlerEventNodeCollection;
 
 #include "global.h"
 
 typedef CollisionHandlerEventNodeCollection< PRIMARY_TYPE > ColliderCollection;
 
 #include "MapCollection.h"
 #include "CollisionHandlerEventNode.h"
 #include "pointerTo.h"
 
 #include <map>
 
 /**
  * Class specification for CollisionHandlerEventNodeCollection
  */
 template <typename T>
 class CollisionHandlerEventNodeCollection : public MapCollection< std::string, PT(CollisionHandlerEventNode<T>) >
 {
 // Data Members
 protected:
    typedef MapCollection< std::string, PT(CollisionHandlerEventNode<T>) > MapCollection;
    typedef std::map< std::string, PT(CollisionHandlerEventNode<T>), std::less<std::string> > ColliderMap;
    //ColliderMap _collider_Ptrs;
    
 // Local Functions
 public:
    CollisionHandlerEventNodeCollection();
    CollisionHandlerEventNodeCollection( const CollisionHandlerEventNodeCollection<T>& collider_collection );
    virtual ~CollisionHandlerEventNodeCollection();
    inline CollisionHandlerEventNodeCollection<T>& operator=( const CollisionHandlerEventNodeCollection<T>& collider_collection );
    //inline void add( const std::string& key, CollisionHandlerEventNode<T>* collider_Ptr );
    //inline void clear();
    inline void detach( const std::string& key );
    inline void detach_all();
    inline CollisionHandlerEventNode<T>* get( const std::string& key );
    inline CollisionHandlerEventNode<T>* get_first_active_collider_found();
    //inline void remove( const std::string& key );
    inline void reparent_to( NodePath& node_path );
    inline void reparent_to( const std::string& key, NodePath& node_path );
 
 // Private Functions
 private:
    
 // Friend Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 CollisionHandlerEventNodeCollection<T>::CollisionHandlerEventNodeCollection()
                                        : MapCollection()
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 CollisionHandlerEventNodeCollection<T>::CollisionHandlerEventNodeCollection( 
                                                         const CollisionHandlerEventNodeCollection<T>& collider_collection )
                                        : MapCollection( collider_collection )
                                        //: _collider_Ptrs( collider_collection._collider_Ptrs )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 CollisionHandlerEventNodeCollection<T>::~CollisionHandlerEventNodeCollection()
 {
    // for each CollisionHandlerEventNode in this CollisionHandlerEventNodeCollection
    /*for ( ColliderMap::const_iterator c_Itr( _collider_Ptrs.begin() ); c_Itr != _collider_Ptrs.end(); ++c_Itr )
    {
        c_Itr->second->remove_node(); // remove the collider from its parent
    }*/
 }
 
 /**
  * operator=() copies the content of the specified CollisionHandlerEventNodeCollection to this 
  * CollisionHandlerEventNodeCollection.
  *
  * @param (const CollisionHandlerEventNodeCollection<T>&) collider_collection
  * @return CollisionHandlerEventNodeCollection<T>&
  */
 template <typename T>
 inline CollisionHandlerEventNodeCollection<T>& CollisionHandlerEventNodeCollection<T>::operator=( 
                                                    const CollisionHandlerEventNodeCollection<T>& collider_collection )
 {
    //_collider_Ptrs = collider_collection._collider_Ptrs;
    MapCollection::operator=( collider_collection );
    
    return *this;
 }
 
 /**
  * clear() removes all CollisionHandlerEventNodes from this CollisionHandlerEventNodeCollection, such that
  * this CollisionHandlerEventNodeCollection will be empty.
  */
 //template <typename T>
 //inline void CollisionHandlerEventNodeCollection<T>::clear()
 //{
    // for each CollisionHandlerEventNode in this CollisionHandlerEventNodeCollection
    /*for ( ColliderMap::const_iterator c_Itr( _collider_Ptrs.begin() ); c_Itr != _collider_Ptrs.end(); ++c_Itr )
    {
        c_Itr->second->remove_node(); // remove the collider from its parent
    }*/
    
    //_collider_Ptrs.clear();
 //}
 
 /**
  * add() adds the specified CollisionHandlerEventNode pointer to this CollisionHandlerEventNodeCollection.
  *
  * @param (const std::string&) key
  * @param (CollisionHandlerEventNode<T> *) collider_Ptr
  */
 //template <typename T>
 //inline void CollisionHandlerEventNodeCollection<T>::add( const std::string& key, CollisionHandlerEventNode<T> * collider_Ptr )
 //{
    //nassertv( collider_Ptr != NULL );
    //_collider_Ptrs.insert( ColliderMap::value_type( key, collider_Ptr ) );
 //}
 
 /**
  * detach() makes the collider of the specified key in this collection incapable of colliding.
  *
  * @param (const std::string&) key
  */
 template <typename T>
 inline void CollisionHandlerEventNodeCollection<T>::detach( const std::string& key )
 {
    PT(CollisionHandlerEventNode<T>) collider_Ptr( MapCollection::get( key ) );
    
    if ( collider_Ptr != NULL )
    {
        collider_Ptr->detach_node();
    }
 }
 
 /**
  * detach_all() makes all colliders in this collection incapable of colliding.
  */
 template <typename T>
 inline void CollisionHandlerEventNodeCollection<T>::detach_all()
 {
    // for each CollisionHandlerEventNode in this CollisionHandlerEventNodeCollection
    for ( MapCollection::iterator c_Itr( MapCollection::begin() ); c_Itr != MapCollection::end(); ++c_Itr )
    {
        c_Itr->detach_node(); // detach the collider from its parent
    }
 }
 
 /**
  * get() returns a pointer to the CollisionHandlerEventNode matching the specified key.
  * If the specified key is not a CollisionHandlerEventNode contained within this collection,
  * then a NULL pointer is returned.
  *
  * @param (const std::string&) key
  * @return CollisionHandlerEventNode<T>*
  */
 template <typename T>
 inline CollisionHandlerEventNode<T>* CollisionHandlerEventNodeCollection<T>::get( const std::string& key )
 {
    MapCollection::iterator collider_Itr( MapCollection::find( key ) );
    
    // if the CollisionHandlerEventNode is not found in ColliderCollection
    if ( collider_Itr == MapCollection::end() )
        return NULL;
    else // the CollisionHandlerEventNode matching the key is found in the ColliderCollection
        return *collider_Itr;
 }
 
 /**
  * get_first_active_collider_found() returns a pointer to the first active 
  * CollisionHandlerEventNode found in this Collection.
  * If no CollisionHandlerEventNode is active, then a NULL pointer is returned.
  *
  * @param (const std::string&) key
  * @return CollisionHandlerEventNode<T>*
  */
 template <typename T>
 inline CollisionHandlerEventNode<T>* CollisionHandlerEventNodeCollection<T>::get_first_active_collider_found()
 {
    MapCollection::iterator end_Itr( MapCollection::end() );
    
    // for each CollisionHandlerEventNode in this CollisionHandlerEventNodeCollection
    for ( MapCollection::iterator c_Itr( MapCollection::begin() ); c_Itr != end_Itr; ++c_Itr )
    {
        // the collider is "considered" (i.e. assumed to be) active if the collider has a parent node
        if ( c_Itr->has_parent() )
            return *c_Itr;
    }
    
    return NULL;
 }
 
 /**
  * remove() removes the CollisionHandlerEventNode matching the specified key
  * from this CollisionHandlerEventNodeCollection.
  *
  * @param (const std::string&) key
  */
 //template <typename T>
 //inline void CollisionHandlerEventNodeCollection<T>::remove( const std::string& key )
 //{
    //ColliderMap::const_iterator collider_Itr( _collider_Ptrs.find( key ) );
    
    // if the CollisionHandlerEventNode is not found in _collider_Ptrs
    //if ( collider_Itr == _collider_Ptrs.end() )
        //return; 
    //else // the CollisionHandlerEventNode matching key is found in _collider_Ptrs
    //{
        //collider_Itr->second->remove_node(); // remove the collider from its parent
        //_collider_Ptrs.erase( collider_Itr );
    //}
 //}
 
 /**
  * reparent_to() makes all colliders in this collection capable of colliding by setting the 
  * parent of all the colliders to the specified NodePath.
  *
  * @param (NodePath&) node_path
  */
 template <typename T>
 inline void CollisionHandlerEventNodeCollection<T>::reparent_to( NodePath& node_path )
 {
    // for each CollisionHandlerEventNode in this CollisionHandlerEventNodeCollection
    for ( MapCollection::iterator c_Itr( MapCollection::begin() ); c_Itr != MapCollection::end(); ++c_Itr )
    {
        c_Itr->reparent_to( node_path ); // reparent the collider to node_path
    }
 }
 
 /**
  * reparent_to() makes the collider of the specified key in this collection capable of colliding
  * by setting the parent of this collider to the specified NodePath.
  *
  * @param (const std::string&) key
  * @param (NodePath&) node_path
  */
 template <typename T>
 inline void CollisionHandlerEventNodeCollection<T>::reparent_to( const std::string& key, NodePath& node_path )
 {
    PT(CollisionHandlerEventNode<T>) collider_Ptr( CollisionHandlerEventNodeCollection<T>::get( key ) );
    
    if ( collider_Ptr != NULL )
    {
        collider_Ptr->reparent_to( node_path );
    }
 }
 
 /** FRIEND FUNCTIONS **/
 
 #endif // COLLISION_HANDLER_EVENT_NODE_COLLECTION_H